/**
 Copyright (c) 2015-2021 PSPDFKit GmbH. All rights reserved.

 THIS SOURCE CODE AND ANY ACCOMPANYING DOCUMENTATION ARE PROTECTED BY INTERNATIONAL COPYRIGHT LAW
 AND MAY NOT BE RESOLD OR REDISTRIBUTED. USAGE IS BOUND TO THE PSPDFKIT LICENSE AGREEMENT.
 UNAUTHORIZED REPRODUCTION OR DISTRIBUTION IS SUBJECT TO CIVIL AND CRIMINAL PENALTIES.
 This notice may not be removed from this file.
 */
exports.defineAutoTests = function() {
  describe("PSPSDFKit (window.PSPDFKit)", function() {
    it("should exist", function() {
      expect(window.PSPDFKit).toBeDefined();
    });

    describe("present", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.present).toBeDefined();
      });
    });

    describe("presentFromAssets", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.presentFromAssets).toBeDefined();
      });
    });

    describe("ScrollMode", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.ScrollMode).toBeDefined();
      });
    });

    describe("PageFitMode", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.PageFitMode).toBeDefined();
      });
    });

    describe("PageScrollDirection", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.PageScrollDirection).toBeDefined();
      });
    });

    describe("SearchType", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.SearchType).toBeDefined();
      });
    });

    describe("ThumbnailBarMode", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.ThumbnailBarMode).toBeDefined();
      });
    });

    describe("ShareFeatures", function() {
      it("should exist", function() {
        expect(window.PSPDFKit.ShareFeatures).toBeDefined();
      });
    });
  });
};

exports.defineManualTests = function(contentEl, createActionButton) {
  createActionButton("Open Document", function() {
    var asset = "www/Guide.pdf";
    var options = {};
    console.log("Opening document " + asset);
    window.PSPDFKit.presentFromAssets(
      asset,
      options,
      function() {
        console.log("Document was successfully loaded.");
      },
      function(error) {
        console.log("Error while loading the document:" + error);
      }
    );
  });

  createActionButton("Open Image ocument", function() {
    var asset = "www/image.jpg";
    var options = {};
    console.log("Opening image document " + asset);
    window.PSPDFKit.presentFromAssets(
      asset,
      options,
      function() {
        console.log("Document was successfully loaded.");
      },
      function(error) {
        console.log("Error while loading the document:" + error);
      }
    );
  });

  createActionButton("Vertical continuous scrolling", function() {
    var asset = "www/Guide.pdf";
    var options = {
      scrollDirection: PSPDFKit.PageScrollDirection.VERTICAL,
      scrollMode: PSPDFKit.ScrollMode.CONTINUOUS,
      title: "Custom Title",
      page: 2,
      useImmersiveMode: true,
      thumbnailBarMode: PSPDFKit.ThumbnailBarMode.THUMBNAIL_BAR_MODE_SCROLLABLE,
      shareFeatures: [],
      disablePrinting: true
    };

    console.log("Opening document " + asset);

    window.PSPDFKit.presentFromAssets(
      asset,
      options,
      function() {
        console.log("Document was successfully loaded.");
      },
      function(error) {
        console.log("Error while loading the document:" + error);
      }
    );
  });

  createActionButton("Password protected document", function() {
    var asset = "www/password.pdf";
    var options = {
      title: "Password protected document",
      password: "test123",
      shareFeatures: [
        PSPDFKit.ShareFeatures.TEXT_SELECTION_SHARING,
        PSPDFKit.ShareFeatures.NOTE_ANNOTATION_SHARING
      ]
    };

    console.log("Opening encrypted document " + asset);

    window.PSPDFKit.presentFromAssets(
      asset,
      options,
      function() {
        console.log("Document was successfully loaded.");
      },
      function(error) {
        console.log("Error while loading the document:" + error);
      }
    );
  });
};
