# PSPDFKit-Cordova

The official plugin to use PSPDFKit with Apache Cordova/PhoneGap/Ionic.

## Support, Issues and License Questions

PSPDFKit offers support for customers with an active SDK license via https://pspdfkit.com/support/request/

Are you [evaluating our SDK](https://pspdfkit.com/try/)? That's great, we're happy to help out! To make sure this is fast, please use a work email and have someone from your company fill out our sales form: https://pspdfkit.com/sales/

## Installation and Integration Steps

### Cordova

```sh
cordova plugin add https://github.com/PSPDFKit/PSPDFKit-Cordova.git
```

### Ionic

```sh
ionic cordova plugin add https://github.com/PSPDFKit/PSPDFKit-Cordova.git
```

Please follow the step-by-step installation instructions below for:

- [Cordova Installation Android](/docs/android#cordova-installation).
- [Cordova Installation iOS](/docs/ios#cordova-installation).
- [Ionic Installation Android](/docs/android#ionic-installation).
- [Ionic Installation iOS](/docs/ios#ionic-installation).

## Requirements

- [Android Cordova Requirements](docs/android#cordova-requirements).
- [Android Ionic Requirements](docs/android#ionic-requirements).
- [iOS Cordova Requirements](docs/ios#cordova-requirements).
- [iOS Ionic Requirements](docs/ios#ionic-requirements).

## Getting Started

Please follow the getting started guides below:

- [New Cordova Project on Android](/docs/android#new-cordova-project)
- [New Ionic Project on Android](/docs/android#new-ionic-project)
- [New Cordova Project on iOS](/docs/ios#new-cordova-project)
- [New Ionic Project on iOS](/docs/ios#new-ionic-project)

## Example Projects

- [Running the PSPDFKit-Demo Cordova Example on Android](/docs/android#running-the-pspdfkit-demo-cordova-example)
- [Running the PSPDFKit-Demo Cordova Example on iOS](/docs/ios#running-the-pspdfkit-demo-cordova-example)
- [Running the PSPDFKit-Demo Ionic Example on Android](/docs/android#running-the-pspdfkit-demo-ionic-example)
- [Running the PSPDFKit-Demo Ionic Example on iOS](/docs/ios#running-the-pspdfkit-demo-ionic-example)

## Documentation

- [Android](/docs/android/README.md)
- [iOS](/docs/ios/README.md)

## API Reference

- [API Reference](/www/PSPDFKit.js)

## Additional Resources

- [How to Manipulate Annotations Programmatically in Cordova](https://pspdfkit.com/blog/2019/how-to-manipulate-annotations-programmatically-in-cordova/)
- [How to Expose Native iOS APIs to Cordova](https://pspdfkit.com/blog/2019/how-to-expose-ios-api-to-cordova/)
- [The All New PSPDFKit-Cordova Plugin](https://pspdfkit.com/blog/2019/pspdfkit-cordova/)

## Troubleshooting

- [Android](/docs/android#troubleshooting)
- [iOS](/docs/ios#troubleshooting)

## Migration Guides

- [Migration Guide from Cordova-Android](/docs/android#migration-guide-from-cordova-android)
- [Migration Guide from Cordova-iOS](/docs/ios#migration-guide-from-cordova-ios)

## License

Copyright 2011-2021 PSPDFKit GmbH. All rights reserved.

THIS SOURCE CODE AND ANY ACCOMPANYING DOCUMENTATION ARE PROTECTED BY AUSTRIAN COPYRIGHT LAW
AND MAY NOT BE RESOLD OR REDISTRIBUTED. USAGE IS BOUND TO THE PSPDFKIT LICENSE AGREEMENT.
UNAUTHORIZED REPRODUCTION OR DISTRIBUTION IS SUBJECT TO CIVIL AND CRIMINAL PENALTIES.

You need a commercial license to use this project. Contact sales@pspdfkit.com for details.

## Contributing

Please ensure [you signed our CLA](https://pspdfkit.com/guides/web/current/miscellaneous/contributing/) so we can accept your contributions.
